// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

// Procedures for zipping and unzipping files.
//............................................
#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include <shellapi.h>
#include <shlobj.h>
#include "Tscmsg.h"
#include "Check.h"
#include "zlib.h"

extern	LPBYTE				lpInBuffer;
extern  LPBYTE				lpOutBuffer;
extern	PACKED_FILE_HEADER	pfhdr;
extern	DWORD				dwCheckCrc32;
extern	BOOL				bCancelOperation;
extern	LARGE_INTEGER		liHalfPercentDup;
extern	HWND				hDialogModeLess;

// Variables for compressing with the zip algorithms.
//...................................................
z_stream		z;
LARGE_INTEGER	liSegment;

// The following procedure is for zipping a file.
// Returns FALSE for i/o errors.
//...............................................
BOOL ZipMyFile(LPBYTE lpOutFile, HANDLE hOutFile, LPBYTE lpInFile, HANDLE hInFile)
{
	ULARGE_INTEGER		ulFileSize;
	ULARGE_INTEGER		ulDelta;
	ULARGE_INTEGER		ulBytesRead;
	ULARGE_INTEGER		ulRemainder;
	DWORD				dwBytesRead;
	DWORD				dwBytesToWrite;
	DWORD				dwBytesWritten;
	int					iError;
	int					iFlush;
	BOOL				bResult = FALSE;
	BOOL				bInit = FALSE;

	ZeroMemory(&z,sizeof(z));
	ulFileSize.QuadPart = GetMyFileSize((LPTSTR)lpInFile,hInFile);

	// Setup the z_stream for the compressor.
	//.......................................
	z.avail_in = 0;
	z.next_out = lpOutBuffer;
	z.avail_out = BUFFER_SIZE_OUT;

	// Initialize the files crc32 value.
	//..................................
	pfhdr.dwFileCrc32 = crc32(0L,Z_NULL,0);

	// Make sure.
	//...........
	pfhdr.uliCompressedFileSize.QuadPart = 0;

	// Initialize the internal stream state for compression.
	//......................................................
	iError = deflateInit(&z,Z_BEST_COMPRESSION);
	if (iError != Z_OK)
	{
		ZlibError(lpInFile,iError,IDS_DEFLATEINIT);
		goto ZipEnd;
	}
	bInit = TRUE;
	
	// Compress the file.
	//...................
	while(ulFileSize.QuadPart > 0)
	{
		// Setup the bytes read for the progress bar.
		//...........................................
		ulBytesRead.QuadPart = 0;

		if (z.avail_in == 0)
		{
			bResult = ReadMyFile((LPTSTR)lpInFile,hInFile,lpInBuffer,BUFFER_SIZE_IN,
								  &dwBytesRead,NULL);
			if (!bResult)
			{
				goto ZipEnd;
			}
			// Set the number of bytes in the input buffer.
			//.............................................
			z.avail_in = dwBytesRead;
			z.next_in = lpInBuffer;

			ulBytesRead.QuadPart = dwBytesRead;

			// Do the crc32 check value.
			//..........................
			pfhdr.dwFileCrc32 = crc32(pfhdr.dwFileCrc32,lpInBuffer,z.avail_in);
		}
		EmptyTheMessageQue();
		if (bCancelOperation == TRUE)
		{
			bResult = FALSE;
			goto ZipEnd;
		}
		// Set the flushing variable for compressing.
		//...........................................
		iFlush = Z_NO_FLUSH;
		if (ulFileSize.QuadPart <= BUFFER_SIZE_IN)
		{
			iFlush = Z_FINISH;
		}
		ulFileSize.QuadPart -= dwBytesRead;

		// Lets go and compress this file.
		//................................
		iError = deflate(&z,iFlush);
		if (iError < 0)
		{
			ZlibError(lpInFile,iError,IDS_DEFLATE);
			bResult = FALSE;
			goto ZipEnd;
		}
		// Write any output if we have some.
		//..................................
		dwBytesToWrite = BUFFER_SIZE_OUT - z.avail_out;
		if (dwBytesToWrite)
		{
			bResult = WriteMyFile((LPTSTR)lpOutFile,hOutFile,lpOutBuffer,dwBytesToWrite,
								  &dwBytesWritten,NULL);
			if (!bResult)
			{
				goto ZipEnd;
			}
			z.avail_out = BUFFER_SIZE_OUT;
			z.next_out = lpOutBuffer;

			// Update the compressed size of the file.
			//........................................
			pfhdr.uliCompressedFileSize.QuadPart += dwBytesWritten;
		}
		EmptyTheMessageQue();
		if (bCancelOperation == TRUE)
		{
			bResult = FALSE;
			goto ZipEnd;
		}
		// Calculate the delta for the progress bar.
		//..........................................
		liSegment.QuadPart += ulBytesRead.QuadPart;
		ulRemainder.QuadPart = 0;
		if (liSegment.QuadPart >= liHalfPercentDup.QuadPart)
		{
			ulRemainder.QuadPart = (liSegment.QuadPart % liHalfPercentDup.QuadPart);
			ulDelta.QuadPart = liSegment.QuadPart / liHalfPercentDup.QuadPart;
			SendMessage(GetDlgItem(hDialogModeLess,IDC_PROGRESS),PBM_DELTAPOS,
					   (WPARAM)ulDelta.LowPart,0);
			liSegment.QuadPart = 0;
		}
		if (ulRemainder.QuadPart)
		{
			liSegment.QuadPart = ulRemainder.QuadPart;
		}
		// See if we are done.
		//....................
		if (iFlush == Z_FINISH && iError == Z_STREAM_END)
		{
			break;
		}
		// We may have more output to get.
		//................................
		if (iFlush == Z_FINISH && iError == Z_OK)
		{
			while(iError != Z_STREAM_END)
			{
				iError = deflate(&z,iFlush);
				if (iError < 0)
				{
					ZlibError(lpInFile,iError,IDS_DEFLATE);
					bResult = FALSE;
					goto ZipEnd;
				}
				dwBytesToWrite = BUFFER_SIZE_OUT - z.avail_out;
				if (dwBytesToWrite)
				{
					bResult = WriteMyFile((LPTSTR)lpOutFile,hOutFile,lpOutBuffer,
										   dwBytesToWrite,&dwBytesWritten,NULL);
					if (!bResult)
					{
						goto ZipEnd;
					}
					z.avail_out = BUFFER_SIZE_OUT;
					z.next_out = lpOutBuffer;

					// Update the compressed size of the file.
					//........................................
					pfhdr.uliCompressedFileSize.QuadPart += dwBytesWritten;
				}
				EmptyTheMessageQue();
				if (bCancelOperation == TRUE)
				{
					bResult = FALSE;
					goto ZipEnd;
				}
			}
			break;
		}
	}
	// No errors so far.
	//..................
	bResult = TRUE;

	ZipEnd:

	if (bInit)
	{
		iError = deflateEnd(&z);
		if (iError != Z_OK)
		{
			ZlibError(lpInFile,iError,IDS_DEFLATEEND);
			bResult = FALSE;
		}
	}
	return(bResult);
}

// The following procedure is for unzipping the file.
// Returns FALSE for i/o errors. If the handle for the
// output file is 0, we are just testing the file.
//....................................................
BOOL UnzipMyFile(LPBYTE lpInFile, HANDLE hInFile, LPBYTE lpOutFile, HANDLE hOutFile)
{
	ULARGE_INTEGER		ulCompFileSize;
	ULARGE_INTEGER		ulFileSize;
	ULARGE_INTEGER		ulBytesRead;
	ULARGE_INTEGER		ulDelta;
	ULARGE_INTEGER		ulRemainder;
	DWORD				dwBytesRead;
	DWORD				dwBytesToWrite;
	DWORD				dwBytesWritten;
	DWORD				dwBytesToRead;
	int					iError;
	int					iFlush;
	BOOL				bInit = FALSE;
	BOOL				bResult = FALSE;

	ZeroMemory(&z,sizeof(z));
	dwCheckCrc32 = crc32(0L,Z_NULL,0);

	ulCompFileSize.QuadPart = pfhdr.uliCompressedFileSize .QuadPart;
	ulFileSize.QuadPart = pfhdr.uliFileSize.QuadPart;

	// Setup the z_stream for the decompressor.
	//.........................................
	z.avail_in = 0;
	z.next_out = lpOutBuffer;
	z.avail_out = BUFFER_SIZE_OUT;

	// Initialize the internal stream state for decompression.
	//........................................................
	iError = inflateInit(&z);
	if (iError != Z_OK)
	{
		ZlibError(lpInFile,iError,IDS_INFLATEINIT);
		goto DzipEnd;
	}
	bInit = TRUE;

	// Decompress the file.
	//.....................
	while(TRUE)
	{
		// Setup bytes read for progress bar.
		//...................................
		ulBytesRead.QuadPart = 0;

		if (ulCompFileSize.QuadPart > 0 && z.avail_in == 0)
		{
			if (ulCompFileSize.QuadPart >= BUFFER_SIZE_IN)
			{
				dwBytesToRead = BUFFER_SIZE_IN;
			}
			else
			{
				dwBytesToRead = ulCompFileSize.LowPart;
			}
			bResult = ReadMyFile((LPTSTR)lpInFile,hInFile,lpInBuffer,dwBytesToRead,
								 &dwBytesRead,NULL);
			if (!bResult)
			{
				goto DzipEnd;
			}
			// Setup the number of bytes in the input buffer.
			//...............................................
			z.avail_in = dwBytesRead;
			z.next_in = lpInBuffer;
			ulCompFileSize.QuadPart -= dwBytesRead;
			ulBytesRead.QuadPart = dwBytesRead;
		}
		EmptyTheMessageQue();
		if (bCancelOperation == TRUE)
		{
			bResult = FALSE;
			goto DzipEnd;
		}
		// Set the flushing variable for decompressing.
		// If the output buffer is large enough to hold
		// everything at once we can use Z_FINISH.
		//.............................................
		iFlush = Z_SYNC_FLUSH;
		if (ulFileSize.QuadPart <= BUFFER_SIZE_OUT && ulCompFileSize.QuadPart == 0)
		{
			iFlush = Z_FINISH;
		}
		iError = Z_OK;

		// Decompress the file.
		//.....................
		iError = inflate(&z,iFlush);
		if (iError < 0)
		{
			ZlibError(lpInFile,iError,IDS_INFLATE);
			goto DzipEnd;
		}
		dwBytesToWrite = BUFFER_SIZE_OUT - z.avail_out;

		// Calculate the crc32 check value.
		//.................................
		dwCheckCrc32 = crc32(dwCheckCrc32,lpOutBuffer,dwBytesToWrite);

		// Write the output to disk unless we are testing the file.
		//.........................................................
		if (hOutFile)
		{
			bResult = WriteMyFile((LPTSTR)lpOutFile,hOutFile,lpOutBuffer,
								   dwBytesToWrite,&dwBytesWritten,NULL);
			if (!bResult)
			{
				goto DzipEnd;
			}
		}
		z.next_out = lpOutBuffer;
		z.avail_out = BUFFER_SIZE_OUT;
		ulFileSize.QuadPart -= dwBytesToWrite;

		// Calculate and display the progress bar.
		//........................................
		if (ulBytesRead.QuadPart > 0)
		{
			liSegment.QuadPart += ulBytesRead.QuadPart;
			ulRemainder.QuadPart = 0;
			if (liSegment.QuadPart >= liHalfPercentDup.QuadPart)
			{
				ulRemainder.QuadPart = (liSegment.QuadPart % liHalfPercentDup.QuadPart);
				ulDelta.QuadPart = liSegment.QuadPart / liHalfPercentDup.QuadPart;
				SendMessage(GetDlgItem(hDialogModeLess,IDC_PROGRESS),PBM_DELTAPOS,
						   (WPARAM)ulDelta.LowPart,0);
				liSegment.QuadPart = 0;
			}
			if (ulRemainder.QuadPart)
			{
				liSegment.QuadPart = ulRemainder.QuadPart;
			}
		}
		// If we have finished, get out of here.
		//......................................
		if (iError == Z_STREAM_END)
		{
			break;
		}
		EmptyTheMessageQue();
		if (bCancelOperation == TRUE)
		{
			bResult = FALSE;
			goto DzipEnd;
		}
	}
	bResult = TRUE;

	DzipEnd:

	if (bInit)
	{
		iError = inflateEnd(&z);
		if (iError != Z_OK)
		{
			ZlibError(lpInFile,iError,IDS_INFLATEEND);
			bResult = FALSE;
		}
	}
	return(bResult);
}

// Determines the zlib error and displays the error procedure message box.
//........................................................................
VOID ZlibError(LPBYTE lpFile, int iError, DWORD dwProcedure)
{
	DWORD		dwError;

	dwError = IDS_Z_UNKNOWN;

	if (iError == Z_MEM_ERROR)
	{
		dwError = IDS_Z_MEM_ERROR;
	}
	else if (iError == Z_DATA_ERROR)
	{
		dwError = IDS_Z_DATA_ERROR;
	}
	else if (iError == Z_BUF_ERROR)
	{
		dwError = IDS_Z_BUFF_ERROR;
	}
	else if (iError == Z_STREAM_ERROR)
	{
		dwError = IDS_Z_STREAM_ERROR;
	}
	SetLastError(dwError);
	ErrorProcedure((LPTSTR)lpFile,dwProcedure,MB_OK);
}
